/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.fermenter;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FermenterRecipeCategory
extends IERecipeCategory<FermenterRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "fermenter");
    private final IDrawableStatic tankOverlay;

    public FermenterRecipeCategory(IGuiHelper helper) {
        super(FermenterRecipe.class, helper, UID, "block.immersiveengineering.fermenter");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/fermenter.png");
        this.setBackground(helper.createDrawable(background, 6, 12, 126, 59));
        this.setIcon(new ItemStack(IEBlocks.Multiblocks.FERMENTER.get()));
        this.tankOverlay = helper.createDrawable(background, 179, 33, 16, 47);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FermenterRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 7).addItemStacks(Arrays.asList(recipe.input.getMatchingStacks()));
        IRecipeSlotBuilder outputSlotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 41);
        if (!((ItemStack)recipe.itemOutput.get()).m_41619_()) {
            outputSlotBuilder.addItemStack((ItemStack)recipe.itemOutput.get());
        }
        if (recipe.fluidOutput != null && !recipe.fluidOutput.isEmpty()) {
            int tankSize = Math.max(250, recipe.fluidOutput.getAmount());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 9).setFluidRenderer(tankSize, false, 16, 47).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient(VanillaTypes.FLUID, (Object)recipe.fluidOutput)).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
    }
}

